# Description
This module provides access to the native Wer report create APIs from a NodeJS based Typescript app. 

# Getting the module
This package is published to the vsts internal npm repo. Please refer to their documentation for setting this up. One you are set up, all you need to do is add this package as a dependency and run npm install, as with any other package. 

# Requirements
This module is strictly windows only. 
To use this module, you must have several things available on your build machine installed globally or as dev dependnecies of your project: nan (recommended @2.1), node-gyp, the C++ build tools in Visual Studio 2015, and Python 2.7. The native component builds during npm install, and  will fail if any of these are not present. 
This module has native components that build when you install it. The Node version it build against is determined by the .npmrc file. The default value is usually the version of Node you have installed, and this may not be what you want. For example, if you are shipping it with 32 bit Electron, version 34.1 (tested and known working with this version) you will need to add the following to the .npmrc file in your package:

`disturl=https://atom.io/download/atom-shell`
`target=0.34.1`
`arch=ia32`

It has only been tested against this version of Electron and Node 5.10, but should be broadly compatible. If it is incompatible with your runtime or the Node version or bitness it compiles for does not match what you are running it under, it will fail at runtime with a DLL load error that will likely bring down the process, so test this thoroughly. It will not fail at compile time for this reason. 

Due to implementation details of the internal npm repo, build may not trigger when you install it. To get around this, add `"install": "npm rebuild",` to you package.json is the scripts section and this will cause it to be built. 

# Usage
Everything you need to send a report is exported directly from the module. There is a method that accepts all of the information needed for the report and multiple interfaces, enums, and constants that the interface knows how to understand. Invalid reports will be rejected with a JS exception explaining the problem. 

# Contributing
I am open to suggestions, bugfixes, and pull requests. If you want to make a topic branch and develop this, clone the repo , run `npm install` and `typings install`, and use gulp to do build and test related tasks. Please make sure "gulp validate-for-publish" succeeds before doing anything else. This lints and builds and copies a few extra files to prepare for publishing. 

To test changes locally, run npm pack from inside the lib folder to make a tgz archive that other packages can use by pointing npm install at it. 